# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: C

def radiant_mirage_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Early rounds (1-3)
    if current_round <= 3:
        if current_round == 1:
            return "C"
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    # Mid rounds (4-7)
    if current_round <= 7:
        if "forgiveness" in opponent_program_code.lower() or "random" in opponent_program_code.lower():
            if opp_history[-1] == "C":
                return "D" if random.random() < 0.7 else "C"
            else:
                return "D" if random.random() < 0.6 else "C"
        else:
            return opp_history[-1]
    
    # Late rounds (8-10)
    if current_round >= 8:
        if "forgiveness" in opponent_program_code.lower() or "random" in opponent_program_code.lower():
            return "D"
        else:
            return opp_history[-1]
    
    return "C"